/*
 *
 * pgpFileMac.h -- Updated for HFS+ support
 *
 */

#ifndef Included_pgpFileMac_h
#define Included_pgpFileMac_h

#include <stdio.h>

#include "pgpTypes.h"
#include "pgpUtilities.h"

PGP_BEGIN_C_DECLARATIONS

#include "pgpOpaqueStructs.h"

struct PGPFileError
{
	PGPFile*		f;			/* The PGPFile for I/O Errors */
	PGPFileOffset	fpos;		/* file position */
	PGPError		error;		/* PGP error code (kPGPError_*) */
	int				syserrno;	/* don't use errno; that's a macro! */
};


enum PGPFileDataType_
{
	kPGPFileDataType_Unknown	= 0,
	kPGPFileDataType_ASCII,
	kPGPFileDataType_Binary,
	
	PGP_ENUM_FORCE( PGPFileDataType )
};

PGPENUM_TYPEDEF( PGPFileDataType_, PGPFileDataType );

struct PGPFile
{
	PGPContextRef	context;
	PGPFileDataType	dataType;
	
	void*				priv;
	PGPSize				(*read) (void *ptr, ByteCount size, PGPFile *file);
	PGPSize				(*write) (void const *ptr, ByteCount size, PGPFile *file);
	PGPError			(*flush) (PGPFile *file);
	PGPError			(*close) (PGPFile *file);
	PGPFileOffset		(*tell) (PGPFile *file);
	PGPError			(*seek) (PGPFile *file, PGPFileOffset offset, int whence);
	PGPBoolean			(*eof) (PGPFile const *file);
	PGPFileOffset		(*sizeAdvise) (PGPFile const *file);
	PGPFileError const*	(*error) (PGPFile const *file);
	void				(*clearError) (PGPFile *file);
	PGPError			(*write2read) (PGPFile *file);
	PGPCFBContext*		(*cfb) (PGPFile const *file);
};

/* Open the file for writing */
PGPFile* pgpFileWriteOpen(PGPContextRef context, FSRef* file, SInt16 forkRefNum, PGPCFBContext* cfb);

/* Open the file for reading */
PGPFile* pgpFileReadOpen(PGPContextRef context, FSRef* file, SInt16 forkRefNum, PGPUICb const* ui,
						 void* ui_arg);
						 
/* Open the file for writing and specify a custom file close function */
PGPFile* pgpFileProcWriteOpen(PGPContextRef context, FSRef* file, SInt16 forkRefNum,
				      		  PGPError (*doClose) (FSRef* file, SInt16 forkRefNum, void* arg),
				      		  void* arg);

/* Same as above, but don't close the fork automatically */
PGPFile* pgpFileWriteOpenDontClose(PGPContextRef context, FSRef* file, SInt16 forkRefNum,
								   PGPCFBContext* cfbp);

PGPFile* pgpFilePipelineOpen(PGPPipeline* head);

PGPFile* pgpFileMemOpen(PGPContextRef context, void* base, size_t len);

PGP_END_C_DECLARATIONS

#define pgpFileRead(p,s,f)		(f)->read(p,s,f)
#define pgpFileWrite(p,s,f)		(f)->write(p,s,f)
#define pgpFileFlush(f)			(f)->flush(f)
#define pgpFileClose(f)			(f)->close(f)
#define pgpFileTell(f)			(f)->tell(f)
#define pgpFileSeek(f,o,w)		(f)->seek(f,o,w)
#define pgpFileEof(f)			(f)->eof(f)
#define pgpFileSizeAdvise(f)	(f)->sizeAdvise(f)
#define pgpFileError(f)			(f)->error(f)
#define pgpFileClearError(f)	(f)->clearError(f)
#define pgpFileWrite2Read(f)	(f)->write2read(f)
#define pgpFileCfb(f)			(f)->cfb(f)

#endif /* Included_pgpFileMac_h */
